﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    public class WhiteboardStaffViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the division list.
        /// </summary>
        /// <value>
        /// The division list.
        /// </value>
        public List<Division> DivisionList { get; set; }

        /// <summary>
        /// Gets or sets the bed list.
        /// </summary>
        /// <value>
        /// The bed list.
        /// </value>
        public List<CheckItem<Bed>> BedList { get; set; }

        /// <summary>
        /// Gets or sets the division id selected.
        /// </summary>
        /// <value>
        /// The division id selected.
        /// </value>
        public string DivisionIdSelected { get; set; }

        /// <summary>
        /// Gets or sets the staff.
        /// </summary>
        /// <value>
        /// The staff.
        /// </value>
        [Required(ErrorMessage = "The Staff field is required!")]
        [ValidateXss]
        public string Staff { get; set; }

        /// <summary>
        /// Gets or sets the division parameter.
        /// </summary>
        /// <value>
        /// The division parameter.
        /// </value>
        public string DivisionParameter { get; set; }

        /// <summary>
        /// Gets or sets the split screen parameter.
        /// </summary>
        /// <value>
        /// The split screen parameter.
        /// </value>
        public string SplitScreenParameter { get; set; }

        /// <summary>
        /// Gets or sets the display PT parameter.
        /// </summary>
        /// <value>
        /// The display PT parameter.
        /// </value>
        public string DisplayPTParameter { get; set; }

        /// <summary>
        /// Gets or sets the gender color parameter.
        /// </summary>
        /// <value>
        /// The gender color parameter.
        /// </value>
        public string GenderColorParameter { get; set; }

        /// <summary>
        /// Gets or sets the sort by parameter.
        /// </summary>
        /// <value>
        /// The sort by parameter.
        /// </value>
        public string SortByParameter { get; set; }

        /// <summary>
        /// Gets or sets the display footer census parameter.
        /// </summary>
        /// <value>
        /// The display footer census parameter.
        /// </value>
        public string DisplayFooterCensusParameter { get; set; }

        /// <summary>
        /// Gets or sets the display staff attending parameter.
        /// </summary>
        /// <value>
        /// The display staff attending parameter.
        /// </value>
        public string DisplayStaffAttendingParameter { get; set; }

        /// <summary>
        /// Gets or sets the scroll rate parameter.
        /// </summary>
        /// <value>
        /// The scroll rate parameter.
        /// </value>
        public int ScrollRateParameter { get; set; }

        /// <summary>
        /// Gets or sets the button save.
        /// </summary>
        /// <value>
        /// The button save.
        /// </value>
        public string ButtonSave { get; set; }

        /// <summary>
        /// Gets or sets the button division changed.
        /// </summary>
        /// <value>
        /// The button division changed.
        /// </value>
        public string ButtonDivisionChanged { get; set; }
    }
}